<!DOCTYPE HTML>
<!--
	TXT by HTML5 UP
	html5up.net | @ajlkn
	Free for personal and commercial use under the CCA 3.0 license (html5up.net/license)
-->
<html lang="en">
	<head>
		<title><?php page_title('','[WEBSITE_TITLE]'); ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=<?php echo DEFAULT_CHARSET; ?>">
		<meta name="description" content="<?php page_description(); ?>">
		<meta name="keywords" content="<?php page_keywords(); ?>">
		<meta name="robots" content="index,follow">
		<meta name="revisit-after" content="14 days">
		<meta name="generator" content="Websitebaker">
		<meta name="viewport" content="width=auto, initial-scale=1">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/klaro.css">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/main.css">
		<?php register_frontend_modfiles('css');?>
	</head>
	<body class="is-preload">
		<div id="page-wrapper">

			<!-- Header -->
				<header id="header">
					<div class="logo container">
						<div>
							<h1><a href="<?= WB_URL;?>" id="logo"><?php page_header(); ?></a></h1>
							<p><?php page_description(); ?></p>
						</div>
					</div>
				</header>

			<!-- Nav -->
				<nav id="nav">
					<?php
						show_menu2(
						0,
						SM2_ROOT,
						SM2_ALL,
						SM2_ALL|SM2_PRETTY,
						'[li]<a href="[url]">[menu_title]</a>',
						'</li>',
						'<ul>',
						'</ul>'
						);
					?>
				</nav>

			<!-- Main -->
				<section id="main">
					<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
					<div class="container">
						<div class="row">
							<div class="col-12">
								<div class="content">
									<article class="box page-content">
										<header>
											<h2>[[ShowRootParent]]</h2>
										</header>
										<section>
											<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
											<?php page_content(); ?>
										</section>
									</article>
								</div>
							</div>
						</div>
					</div>
				</section>

			<!-- Footer -->
				<footer id="footer">
					<div class="container">
						<div class="row gtr-200">
							<div class="col-12">

								<!-- Contact -->
									<section>
										<h2 class="major"><span>Get in touch</span></h2>
										<ul class="contact">
											<li><a class="icon style2 fa-envelope" href="mailto:info@ruebenwurzel.de"><span class="label">E-Mail</span></a></li>
											<li><a class="icon brands fa-facebook-f" href="https://www.facebook.com/matthias.gallas"><span class="label">Facebook</span></a></li>
											<li><a class="icon brands fa-instagram" href="https://www.instagram.com/matthiasgallas/"><span class="label">Twitter</span></a></li>
										</ul>
									</section>

							</div>
						</div>

						<!-- Copyright -->
							<div id="copyright">
								<ul class="menu">
									<li><?php page_footer(); ?></li><li>Design: <a href="https://html5up.net">HTML5 UP</a></li>
								</ul>
							</div>
					</div>
				</footer>

		</div>

		<!-- Scripts -->
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.dropotron.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.scrolly.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/browser.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/breakpoints.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/util.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/main.js"></script>
		<!-- automatically include optional WB module file frontend_body.js should be always set -->
		<?php register_frontend_modfiles_body('js'); ?>
		<!-- add Klaro Cookie Banner -->
		<script defer  src="<?= TEMPLATE_DIR; ?>/assets/js/config.js"></script>
		<script
			defer
			data-config="klaroConfig"
			src="<?= TEMPLATE_DIR; ?>/assets/js/klaro-no-css.js">
		</script>	

	</body>
</html>